      $SET ANS85 MF"10" NOOSVS NOVSC2 NOQUAL DEFAULTBYTE"00"
      *******************************************************************
      *-----------------------------------------------------------------*
      *                                                                 *
      *        Copyright(c) by Bernd Riemke                             *
      *                        Riemke-IT Solutions                      *
      *                        An den Ruschen 27a                       *
      *                        D-28816 Stuhr                            *
      *                                                                 *
      *-----------------------------------------------------------------*
      $SET ANS85 CASE
      *
      *
      *        API-MsgBoxen.CBL      Windows MessageBoxen ber
      *        ----------------      APIs aufrufen
      *                              --------------------------
      *
      *        LETZTE NDERUNG:
      *        ================
      *
      *        01.01.2017  Bernd Riemke
      *                    - Angelegt
      *
      *
      *=================================================================
       IDENTIFICATION DIVISION.
       PROGRAM-ID.             API-MESSAGEBOXEN.
       AUTHOR.                 BERND RIEMKE.
       INSTALLATION.           BERND RIEMKE.
       DATE-WRITTEN.           01-Januar-2017.
       DATE-COMPILED.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER.        IBM-PC-COMP.
       OBJECT-COMPUTER.        IBM-PC-COMP.
       SPECIAL-NAMES.          CALL-CONVENTION 66 IS WINAPI
                               DECIMAL-POINT      IS COMMA.
      *
      *
      ******************************************************************
       INPUT-OUTPUT   SECTION.
      *-----------------------
       FILE-CONTROL.
      *-------------
      *
      *
      ******************************************************************
       DATA DIVISION.
      *--------------
       FILE SECTION.
      *
      *
      ******************************************************************
       WORKING-STORAGE SECTION.
      *------------------------
      *

       01  VARIABLEN.
      *USER32.DLL
           05  DLL-POINTER             USAGE PROCEDURE-POINTER.
           05  DUM-POINTER             USAGE PROCEDURE-POINTER.

      *******************************************************************

      *>   MessageBox Parameter
       77  AktWindow    pic xxxx comp-5. *> Window handle, zero is
                                         *> Windows Desktop
       77  lpszText             pointer. *> Pointer zu MessageBox Text
       77  lpszCaption          pointer. *> Window Titelzeile
       77  uType       pic xxxx comp-5.  *> Message Box Type
       77  nReturn     pic xxxx comp-5.  *> MessageBox Return Wert
       77  szCaption   pic x(256).       *> MessageBox Window Titel
                                         *> Muss mit X"00" abschliessen!
       77  szText      pic x(256).       *> MessageBox Text
                                         *> Muss mit X"00" abschliessen!

      *>  Die verschiedenen MessageBox Buttons
       78  MB-OK                           value   0.
       78  MB-OKCANCEL                     value   1.
       78  MB-ABORTRETRYIGNORE             value   2.
       78  MB-YESNOCANCEL                  value   3.
       78  MB-YESNO                        value   4.
       78  MB-RETRYCANCEL                  value   5.
      *>  Die verschiedenen MessageBox Icons
       78  MB-ICONSTOP                     value  16.
       78  MB-ICONQUESTION                 value  32.
       78  MB-ICONEXCLAMATION              value  48.
       78  MB-ICONINFORMATION              value  64.
      *>  MessageBox "Default" Button
       78  MB-DEFBUTTON1                   value   0.
       78  MB-DEFBUTTON2                   value 256.
       78  MB-DEFBUTTON3                   value 512.
      *>  MessageBox Button Return Werte
       78  IDOK                            value   1.
       78  IDCANCEL                        value   2.
       78  IDABORT                         value   3.
       78  IDRETRY                         value   4.
       78  IDIGNORE                        value   5.
       78  IDYES                           value   6.
       78  IDNO                            value   7.
      *>   MessageBox Modality Flags
       78  MB-APPLMODAL                    value       0.
       78  MB-SYSTEMMODAL                  value    4096.
       78  MB-TASKMODAL                    value    8192.
       78  MB-HELP                         value   16384.
       78  MB-NOFOCUS                      value   32768.
       78  MB-SETFOREGROUND                value   65536.
       78  MB-DEFAULT-DESKTOP-ONLY         value  131072.
       78  MB-TOPMOST                      value  262144.
       78  MB-RIGHT                        value  524288.
       78  MB-RTLREADING                   value 1048676.
       78  MB-SERVICE-NOTIFICATION         value 2097152. *>NT4          Aktuell ab NT 4.0
      *78  MB-SERVICE-NOTIFICATION         value 4194304. *>NT3.5        Altes Format
       78  MB-SERVICE-NOTIFICATION-NT3X    value 4194304. *>NT3.5
       78  MB-TYPEMASK                     value      15.
       78  MB-ICONMASK                     value     240.
       78  MB-DEFMASK                      value    3840.
       78  MB-MODEMASK                     value   12288.
       78  MB-MISCMASK                     value   49152.

      *******************************************************************

       78 UNICODE                      VALUE 1.
       COPY "WINTYPES.CPY".

      *
      ******************************************************************
       LINKAGE SECTION.
      *----------------
      *
      *
      * Linkage zwischen Hauptprogramm und diesem...
       COPY "API-MSGBOX.CPY".


      ******************************************************************
       PROCEDURE DIVISION USING LINK-API-MSGBOX.
      *-----------------------------------------
      *

           CALL "COB32API".

           PERFORM SET-POINTER.

           IF  LINK-API-MSGBOX-FEHLER-NR = 0
               PERFORM CALL-MSGBOX-API
           END-IF

           EXIT PROGRAM.
      *
           STOP RUN.
      *
      ******************************************************************
       CALL-MSGBOX-API SECTION.
      *----------------------------
      *


         *> Kopfzeile bertragen
           STRING LINK-API-MSGBOX-KOPF DELIMITED BY "   "
                  X"00" DELIMITED BY SIZE
                  INTO   SZCAPTION
           END-STRING.
           SET LPSZCAPTION TO ADDRESS OF SZCAPTION.


         *> Textzeilen
           STRING LINK-API-MSGBOX-Text1 DELIMITED BY "   "
                  x'0D0A'               DELIMITED BY SIZE
                  LINK-API-MSGBOX-Text2 DELIMITED BY "   "
                  x'0D0A'               DELIMITED BY SIZE
                  LINK-API-MSGBOX-Text3 DELIMITED BY "   "
                  X"00"                 DELIMITED BY SIZE
                  INTO   SZTEXT
           END-STRING.
           SET LPSZTEXT    TO ADDRESS OF SZTEXT.

          *> Button und Type
           INITIALIZE uType.
           EVALUATE FUNCTION UPPER-CASE(LINK-API-MSGBOX-BUTTON)

               WHEN "OK"
                     CONTINUE
               WHEN "OKCANCEL"
                     ADD 1 TO uType
               WHEN "ABORTRETRYIGNORE"
                     ADD 2 TO uType
               WHEN "YESNOCANCEL"
                     ADD 3 TO uType
               WHEN "YESNO"
                     ADD 4 TO uType
               WHEN "RETRYCANCEL"
                     ADD 5 TO uType

               WHEN OTHER
                    MOVE 999 TO LINK-API-MSGBOX-FEHLER-NR
                    MOVE "Falsche Buttons" TO LINK-API-MSGBOX-FEHLER-TXT
                    EXIT SECTION

           END-EVALUATE.

           *> Window Typen

           EVALUATE FUNCTION UPPER-CASE(LINK-API-MSGBOX-TYPE)

               WHEN "FEHLER"
                     ADD 16 TO uType

               WHEN "FRAGE"
                     ADD 32 TO uType

               WHEN "INFORMATION"
                     ADD 64 TO uType

               WHEN "HINWEIS"
                     ADD 48 TO uType

               WHEN OTHER
                    MOVE 998 TO LINK-API-MSGBOX-FEHLER-NR
                    MOVE "Falscher Typ"    TO LINK-API-MSGBOX-FEHLER-TXT
                    EXIT SECTION


           END-EVALUATE.

      * Erzeuge das MessageBox Window nach den Vorgaben...
           CALL WINAPI 'MessageBoxA'
               USING BY VALUE AktWindow
                     BY VALUE LPSZTEXT
                     BY VALUE LPSZCAPTION
                     BY VALUE UTYPE
                    RETURNING NRETURN
           END-CALL.

           EVALUATE NRETURN
               WHEN 1
                    MOVE 1    TO LINK-API-MSGBOX-RETURN  *> OK
               WHEN 2
                    MOVE 2    TO LINK-API-MSGBOX-RETURN  *> CANCEL
               WHEN 3
                    MOVE 4    TO LINK-API-MSGBOX-RETURN  *> ABORT
               WHEN 4
                    MOVE 3    TO LINK-API-MSGBOX-RETURN  *> RETRY
               WHEN 5
                    MOVE 5    TO LINK-API-MSGBOX-RETURN  *> IGNORE
               WHEN 6
                    MOVE 6    TO LINK-API-MSGBOX-RETURN  *> YES
               WHEN 7
                    MOVE 7    TO LINK-API-MSGBOX-RETURN  *> NO
               WHEN OTHER
                    MOVE ZERO TO LINK-API-MSGBOX-RETURN  *> Fehler !?
           END-EVALUATE.


      *
      *
           EXIT.
      *
      ******************************************************************
       SET-POINTER SECTION.
      *--------------------

      *
      * Dummy-DLL Pointer ermitteln
      *
           SET DUM-POINTER             TO ENTRY  "DUMMY.DLL".
      *
      *
      * ABFRAGE AUF DIE MS-WINDOWS-DLL "USER32.DLL" (MessageBox Funkt.)
      *

           SET DLL-POINTER             TO ENTRY  "USER32.DLL".
           IF  DUM-POINTER = DLL-POINTER
               MOVE 1001               TO LINK-API-MSGBOX-FEHLER-NR
               MOVE "ERROR USER32.DLL DID NOT LOAD"
                 TO  LINK-API-MSGBOX-FEHLER-TXT
           END-IF.

       SET-POINTER-EE.
           EXIT.
      *
      ******************************************************************
      ******************************************************************
      ******************************************************************
      ******************************************************************
      ******************************************************************
